------------------------------------------------------------------
---- SourceCode Import STEP 3 ------------------------------------
------------------------------------------------------------------
BEGIN

    SET NOCOUNT ON;

    -- Migrate existing legacy values into new CM values
    UPDATE c
       SET c.[Name] = CASE WHEN c.[Name] = '' THEN lc.[TITLE] ELSE c.[Name] END,
           c.[Description] = CASE WHEN c.[Description] = '' THEN  lc.[DESCRIPTION] ELSE c.[Description] END,
           c.[StartDate] = COALESCE(c.[StartDate], lc.[BEGINS_DATE]),
           c.[EndDate] = COALESCE(c.[EndDate], lc.[ENDS_DATE])
      FROM [dbo].[CampaignMain] c
            INNER JOIN [dbo].[Campaign] lc ON c.[LegacyCampaignCode] = lc.[CAMPAIGN_CODE];

    UPDATE s
       SET s.[Description] = COALESCE(s.[Description], ls.[DESCRIPTION])
      FROM [dbo].[SourceCode] s
            INNER JOIN [dbo].[Appeal] ls ON s.[Code] = ls.[APPEAL_CODE];

    -- Perform the synchronizations that did not occur because the triggers were disabled
   INSERT INTO [dbo].[Gen_Tables] ([CODE], [UPPER_CODE], [DESCRIPTION], [TABLE_NAME],[CREATED_BY],[UPDATED_BY])
    SELECT i.[Code], i.[Code], COALESCE(i.[Description],''), 'SOURCE_CODE','MANAGER','MANAGER' 
      FROM [dbo].[SourceCode] i
     WHERE NOT EXISTS (SELECT 1 FROM [dbo].[Gen_Tables] WHERE [TABLE_NAME] = 'SOURCE_CODE' AND [CODE] = i.[Code]);
    
    INSERT INTO [dbo].[Appeal] ([APPEAL_CODE], [TITLE], [DESCRIPTION], [APPEAL_TYPE], [CAMPAIGN_CODE])
    SELECT i.[Code], i.[Code], COALESCE(i.[Description],''), '', c.[LegacyCampaignCode]
      FROM [dbo].[SourceCode] i 
            INNER JOIN [dbo].[SourceCodeTypeRef] sctr ON i.[SourceCodeTypeCode] = sctr.[SourceCodeTypeCode]
            INNER JOIN [dbo].[SolicitationMain] s ON i.[SolicitationKey] = s.[SolicitationKey]
            INNER JOIN [dbo].[AppealMain] a ON s.[AppealKey] = a.[AppealKey]
            INNER JOIN [dbo].[CampaignMain] c ON a.[CampaignKey] = c.[CampaignKey]
     WHERE NOT EXISTS (SELECT 1 FROM [dbo].[Appeal] WHERE [APPEAL_CODE] = i.[Code]);

    INSERT INTO [dbo].[Campaign] ([CAMPAIGN_CODE], [TITLE], [DESCRIPTION], [DEFAULT_FUND], [GOAL], [BEGINS_DATE], [ENDS_DATE], [IS_PERPETUAL])
    SELECT i.[LegacyCampaignCode], i.[Name], COALESCE(i.[Description],''), '', i.[TargetRevenue], i.[StartDate], i.[EndDate], 0 
      FROM [dbo].[CampaignMain] i
     WHERE NOT EXISTS (SELECT 1 FROM [dbo].[Campaign] WHERE [CAMPAIGN_CODE] = i.[LegacyCampaignCode])
END
GO

-- Re-enable the triggers 
ALTER TABLE [dbo].[CampaignMain] ENABLE TRIGGER ALL;
ALTER TABLE [dbo].[SourceCode] ENABLE TRIGGER ALL;




